<?php

// Determine what locale to use
switch (PHP_OS)
{
	case 'WINNT':
	case 'WIN32':
		$locale = 'russian';
		break;

	case 'FreeBSD':
	case 'NetBSD':
	case 'OpenBSD':
		$locale = 'ru_RU.ISO8859-5';
		break;

	default:
		$locale = 'ru_RU';
		break;
}

// Attempt to set the locale (required for fulltext indexing to work correctly)
setlocale(LC_CTYPE, $locale);


// Language definitions for frequently used strings
$lang_common = array(

// Text orientation and encoding
'lang_direction'		=>	'LTR',	// LTR (Left-To-Right) or RTL (Right-To-Left)
'lang_encoding'			=>	'windows-1251',

// Notices
'Bad request'			=>	' . ,       .',
'No permission'			=>	'        .',
'Bad referer'			=>	' .        . ,     .   , ,   \' URL\'    / , ,       URL.',

// Miscellaneous (used in many scripts)
'Options'				=>	'',//'Options',
'Actions'				=>	'',//'Actions',
'Submit'				=>	'', //'Submit',	// "name" of submit buttons
'Banned message'		=>	'  ,     ().     - ,     ',
'Never'					=>	'',
'Today'					=>	'',
'Yesterday'				=>	'',
'First page'			=>	'&nbsp;',
'Last page'				=>	'&nbsp;',
'Info'					=>	'',		// a common table header
'Go back'				=>	' ',//'Go back',
'Maintenance'			=>	'',//'Maintenance',
'Redirecting'			=>	'',//'Redirecting',
'Click redirect'		=>	' ,       (       )',
'Login required'		=>	'      .',
'Login'					=>  '',
'or'					=>  '',
'register'				=>  '',//'register',
'on'					=>	'',		// as in "BBCode is on"
'off'					=>	'',
'Invalid e-mail'		=>	'E-mail ,     .',
'required field'		=>	'     .',	// for javascript form validation
'Last post'				=>	' ',
'by'					=>	'by',	// as in last post by someuser
'Username'				=>	'',
'E-mail'				=>	'E-mail',
'Registered'			=>	'',
'Message'				=>	'',
'Topic'					=>	'',
'Forum'					=>	'',
'Posts'					=>	'',
'Replies'				=>	'',
'Author'				=>	'',
'Pages'					=>	'',
'and'					=>	'',

// Title
'Title'					=>	'',//'Title',
'Member'				=>	'',	// Default title
'Moderator'				=>	'',
'Administrator'			=>	'',
'Banned'				=>	'',//'Banned',
'Guest'					=>	'',

// Stuff for include/parser.php
'BBCode error'			=>	'  BBCode  , .',
'BBCode error 1'		=>	'   [/quote].',
'BBCode error 2'		=>	'   [code].',
'BBCode error 3'		=>	'   [/code].',
'BBCode error 4'		=>	'      [quote].',
'BBCode error 5'		=>	'      [/quote].',

// Stuff for the navigator (top of every page)
'Home'					=>	'',
'User list'				=>	'',
'Rules'					=>  '',
'Search'				=>  '',
'Register'				=>  '',
'Login'					=>  '',
'Not logged in'			=>  '  .',
'Profile'				=>	'',
'Logout'				=>	'',
'Logged in as'			=>	' ',
'Admin'					=>	'',
'Last visit'			=>	'   ',

// Stuff for the page footer
'Show new posts'		=>	'     ',
'Show unanswered posts'	=>	'   ',
'Show your posts'		=>	'  ',
'Mark all as read'		=>	'    ',
'Jump to'				=>	'',
'Go'					=>	'  ',		// submit button in forum jump
'Move topic'			=>  ' ',
'Open topic'			=>  ' ',
'Close topic'			=>  ' ',
'Unstick topic'			=>  ' ',
'Stick topic'			=>  ' ',
'Edit subscribers'		=>  ' '

);
